// ==UserScript==
// @name         5ch ジャンプボタン
// @namespace    http://tampermonkey.net/
// @version      1.1
// @description  最後の投稿と1番目の投稿にジャンプするボタンを設置し、ナビに「>>1」リンクを追加するスクリプト（スクロール位置調整対応）
// @author       ChatGPT
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';

    // 🔒 iframe内なら何もせず終了
    if (window.top !== window.self) return;

    // スクロール位置の微調整（px単位）
    // ヘッダーの高さや固定要素に合わせて調整してください
    const scrollOffsetMargin = 10; // 外側余白的な調整
    const scrollOffsetPadding = 0; // 内側余白的な調整（必要なら）

    function createJumpButton() {
        // ▼ 最後の投稿へジャンプボタン
        const btnDown = document.createElement('button');
        btnDown.textContent = '▼';
        Object.assign(btnDown.style, {
            position: 'fixed',
            bottom: '5px',
            right: '20px',
            zIndex: '9999',
            padding: '10px 12px',
            backgroundColor: 'rgba(0,0,0,0.7)',
            color: 'white',
            border: 'none',
            borderRadius: '4px',
            cursor: 'pointer',
            fontSize: '14px',
            lineHeight: '1',
            boxShadow: '0 2px 6px rgba(0,0,0,0.3)',
        });
        btnDown.title = 'ページ内の最後のpostidにジャンプ';

        btnDown.addEventListener('mouseenter', () => {
            btnDown.style.backgroundColor = 'rgba(0,0,0,0.85)';
        });
        btnDown.addEventListener('mouseleave', () => {
            btnDown.style.backgroundColor = 'rgba(0,0,0,0.7)';
        });

        btnDown.addEventListener('click', () => {
            const posts = document.querySelectorAll('.postid');
            if (posts.length === 0) {
                alert('postid要素が見つかりません。');
                return;
            }
            const lastPost = posts[posts.length - 1];
            lastPost.scrollIntoView({ behavior: 'smooth', block: 'center' });
        });

        document.body.appendChild(btnDown);

        // ▲ 1番目の投稿（id=1）へジャンプボタン
        const btnUp = document.createElement('button');
        btnUp.textContent = '▲';
        Object.assign(btnUp.style, {
            position: 'fixed',
            bottom: '45px', // ▼ボタンの上に配置
            right: '20px',
            zIndex: '9999',
            padding: '10px 12px',
            backgroundColor: 'rgba(0,0,0,0.7)',
            color: 'white',
            border: 'none',
            borderRadius: '4px',
            cursor: 'pointer',
            fontSize: '14px',
            lineHeight: '1',
            boxShadow: '0 2px 6px rgba(0,0,0,0.3)',
        });
        btnUp.title = 'ページ内の最初のpostid（id=1）にジャンプ';

        btnUp.addEventListener('mouseenter', () => {
            btnUp.style.backgroundColor = 'rgba(0,0,0,0.85)';
        });
        btnUp.addEventListener('mouseleave', () => {
            btnUp.style.backgroundColor = 'rgba(0,0,0,0.7)';
        });

        btnUp.addEventListener('click', () => {
            const firstPost = document.getElementById('1');
            if (!firstPost) {
                alert('id=1の投稿が見つかりません。');
                return;
            }
            const rect = firstPost.getBoundingClientRect();
            const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
            const targetY = scrollTop + rect.top - scrollOffsetMargin - scrollOffsetPadding;

            window.scrollTo({
                top: targetY,
                behavior: 'smooth'
            });
        });

        document.body.appendChild(btnUp);
    }

    function insertReply1Link() {
        const url = window.location.href;
        const match = url.match(/\/test\/read\.cgi\/([^\/]+)\/(\d+)/);
        if (!match) return;

        const board = match[1];
        const threadId = match[2];
        const href = `../test/read.cgi/${board}/${threadId}/1`;

        const menuUls = document.querySelectorAll('.navmenu .menujust');
        menuUls.forEach(menuUl => {
            if (!menuUl.querySelector('.reply_link')) {
                const a = document.createElement('a');
                a.href = href;
                a.rel = 'noopener noreferrer';
                a.target = '_blank';
                a.className = 'reply_link';
                a.textContent = '>>1';
                a.style.setProperty('color', '#80cbc4', 'important');

                const li = document.createElement('li');
                li.className = 'menubottomnav';
                li.appendChild(a);

                menuUl.insertBefore(li, menuUl.firstChild);
            }
        });
    }

    function init() {
        createJumpButton();
        insertReply1Link();
    }

    if (document.readyState === 'loading') {
        window.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
